# SessionScribe Development Guide

## Build Commands
- Build/Run: Open in Xcode and press ⌘+R
- Archive: Product > Archive in Xcode
- Clean: Product > Clean Build Folder (⇧⌘K)

## Code Structure
- MVVM Architecture (Models/, ViewModels/, Views/)
- Services: RecordingService, TranscriptionService
- Managers: DatabaseManager, OpenAIManager, PermissionsManager

## Style Guidelines
- Indentation: 2 spaces
- Naming: camelCase for variables/functions, PascalCase for types
- Types: Use explicit type declarations when not obvious
- SwiftUI Views: Extract subviews for reuse and readability
- Extensions: Use for organizing functionality
- Comments: Document complex logic and public interfaces
- Error handling: Use descriptive try/catch with specific error types

## UI Components
- Use AppColors for color palette
- Follow DesignSystem for consistent styling
- Reuse common components (AppButton, CardView, etc.)

## API Integration
- API keys stored securely in Keychain
- Model responses parsed through dedicated model types